﻿-- STOK_KARTLARI tablosunda StokIsmi alanı için index yönetimi
-- Önce StokIsmi alanı üzerindeki mevcut tüm index'leri bul ve drop et
DECLARE @IndexName NVARCHAR(128)
DECLARE @SQL NVARCHAR(MAX)

DECLARE index_cursor CURSOR FOR
SELECT i.name
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE i.object_id = OBJECT_ID('STOK_KARTLARI')
  AND c.name = 'StokIsmi'
  AND i.type > 0 -- Heap olmayan index'ler (clustered ve nonclustered)
  AND i.is_primary_key = 0 -- Primary key değil
  AND i.is_unique_constraint = 0 -- Unique constraint değil

OPEN index_cursor
FETCH NEXT FROM index_cursor INTO @IndexName

WHILE @@FETCH_STATUS = 0
BEGIN
    SET @SQL = 'DROP INDEX ' + QUOTENAME(@IndexName) + ' ON STOK_KARTLARI'
    EXEC sp_executesql @SQL
    PRINT 'Dropped index: ' + @IndexName
    
    FETCH NEXT FROM index_cursor INTO @IndexName
END

CLOSE index_cursor
DEALLOCATE index_cursor

-- Yeni index'i oluştur
CREATE INDEX IDX_STOK_KARTLARI_StokIsmi ON STOK_KARTLARI(StokIsmi)
PRINT 'Created index: IDX_STOK_KARTLARI_StokIsmi'
GO
