-- ============================================
-- BonusHelper2026 - Master Database Setup
-- ============================================
-- Bu script BONUS_HELPER veritabanını oluşturur
-- Çalıştırma: SQL Server Management Studio'da master veritabanına bağlıyken çalıştırın
-- Sıra: İlk önce bu script çalıştırılmalıdır

USE [master]
GO

-- BONUS_HELPER veritabanını oluştur (eğer yoksa)
IF NOT EXISTS (SELECT name FROM sys.databases WHERE name = N'BONUS_HELPER')
BEGIN
    PRINT 'BONUS_HELPER veritabanı oluşturuluyor...'
    
    CREATE DATABASE [BONUS_HELPER]
    
    PRINT '✓ BONUS_HELPER veritabanı başarıyla oluşturuldu.'
    PRINT ''
    PRINT 'Sonraki adımlar:'
    PRINT '  1. 01_Create_AYARLAR_Table.sql (Tablolar + Seed Data)'
    PRINT '  2. 02_PENDING_OPERATIONS.sql (Onay Sistemi)'
    PRINT ''
END
ELSE
BEGIN
    PRINT '⚠ BONUS_HELPER veritabanı zaten mevcut.'
    PRINT '  Devam edilebilir - tablo oluşturma scriptlerini çalıştırın.'
    PRINT ''
END
GO
