-- ============================================
-- Database Migrations Tracking Table
-- ============================================
-- Bu tablo uygulamanın schema migration geçmişini tutar
-- Her migration bir kez çalıştırılır ve kaydedilir

USE [BONUS_HELPER]
GO

-- DB_MIGRATIONS tablosu (eğer yoksa oluştur)
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DB_MIGRATIONS]') AND type in (N'U'))
BEGIN
    CREATE TABLE [dbo].[DB_MIGRATIONS](
        [Id] [int] IDENTITY(1,1) NOT NULL,
        [Version] [int] NOT NULL,
        [Description] [nvarchar](250) NOT NULL,
        [Filename] [nvarchar](100) NOT NULL,
        [AppliedDate] [datetime] NOT NULL DEFAULT GETDATE(),
        [Success] [bit] NOT NULL DEFAULT 1,
        [ErrorMessage] [nvarchar](max) NULL,
        [ExecutionTimeMs] [int] NULL,
     CONSTRAINT [PK_DB_MIGRATIONS] PRIMARY KEY CLUSTERED ([Id] ASC),
     CONSTRAINT [UK_DB_MIGRATIONS_Version] UNIQUE ([Version])
    )
    
    PRINT '✓ DB_MIGRATIONS tablosu oluşturuldu.'
END
ELSE
BEGIN
    PRINT '⚠ DB_MIGRATIONS tablosu zaten mevcut.'
END
GO

-- Index ekle (performans için)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_DB_MIGRATIONS_Version')
BEGIN
    CREATE NONCLUSTERED INDEX [IX_DB_MIGRATIONS_Version] 
    ON [dbo].[DB_MIGRATIONS]([Version] DESC)
    
    PRINT '✓ Version indeksi oluşturuldu.'
END
GO

-- İlk migration kaydını ekle (bu scriptin kendisi)
IF NOT EXISTS (SELECT * FROM [dbo].[DB_MIGRATIONS] WHERE Version = 0)
BEGIN
    INSERT INTO [dbo].[DB_MIGRATIONS] (Version, Description, Filename, Success)
    VALUES (0, 'Migration sistemi başlatıldı', '00_DB_MIGRATIONS_Table.sql', 1)
    
    PRINT '✓ İlk migration kaydı eklendi (Version 0).'
END
GO

PRINT ''
PRINT '============================================'
PRINT 'Migration sistemi hazır!'
PRINT '============================================'
PRINT ''
PRINT 'Kullanım:'
PRINT '  - Her yeni schema değişikliği için Scripts/Migrations/ klasörüne'
PRINT '    numaralı SQL dosyası ekleyin (örn: 001_Add_Column.sql)'
PRINT '  - Uygulama başlangıcında otomatik olarak uygulanmamış'
PRINT '    migrationlar çalıştırılır'
PRINT '  - Manuel çalıştırmak için FrmDatabaseSetup formundaki'
PRINT '    "Schema Güncelle" butonunu kullanın'
PRINT ''
GO
